/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.mainmenu;

import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiNpcName;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.select.GuiTextureSelection;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataDisplay;

public class GuiNpcDisplay
extends GuiNPCInterface2
implements ITextfieldListener,
IGuiData,
ISubGuiListener {
    private final DataDisplay display;
    private boolean enableInvisibleNpcs;
    private float baseHitBoxWidth;
    private float baseHitBoxHeight;
    private final DecimalFormat df = new DecimalFormat("#.#");

    public GuiNpcDisplay(EntityNPCInterface npc) {
        super(npc, 1);
        this.display = npc.display;
        Client.sendData(EnumPacketServer.MainmenuDisplayGet, new Object[0]);
        this.baseHitBoxWidth = npc.baseWidth;
        this.baseHitBoxHeight = npc.baseHeight;
        if (npc instanceof EntityCustomNpc && this.display.getModel() != null) {
            ModelData modeldata = ((EntityCustomNpc)npc).modelData;
            this.baseHitBoxWidth = modeldata.entity.field_70130_N;
            this.baseHitBoxHeight = modeldata.entity.field_70131_O;
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.display.setShowName(button.getValue());
                break;
            }
            case 1: {
                NoppesUtil.requestOpenGUI(EnumGuiType.CreationParts);
                break;
            }
            case 2: {
                this.display.setSkinUrl("");
                this.display.setSkinPlayer(null);
                this.display.skinType = (byte)button.getValue();
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.setSubGui(new GuiTextureSelection(this.npc, this.npc.display.getSkinTexture(), "png", 0));
                break;
            }
            case 4: {
                this.display.setShadowType(button.getValue());
                break;
            }
            case 5: {
                this.display.setHasLivingAnimation(button.getValue() == 0);
                break;
            }
            case 7: {
                this.display.setVisible(button.getValue());
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.setSubGui(new GuiTextureSelection(this.npc, this.npc.display.getCapeTexture(), "png", 1));
                break;
            }
            case 9: {
                this.setSubGui(new GuiTextureSelection(this.npc, this.npc.display.getOverlayTexture(), "png", 2));
                break;
            }
            case 10: {
                this.display.setBossbar(button.getValue());
                break;
            }
            case 12: {
                this.display.setBossColor(button.getValue());
                break;
            }
            case 13: {
                this.display.setHitboxState((byte)button.getValue());
                break;
            }
            case 14: {
                String name = this.display.getRandomName();
                this.display.setName(name);
                this.getTextField(0).setFullText(name);
                break;
            }
            case 15: {
                this.setSubGui(new SubGuiNpcName(this.display));
                break;
            }
            case 16: {
                this.setSubGui(new SubGuiNpcAvailability(this.display.getAvailability(), this));
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        this.func_73866_w_();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 4;
        int lID = 0;
        this.addLabel(new GuiNpcLabel(lID++, "gui.name", this.guiLeft + 5, y + 5));
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.field_146289_q, this.guiLeft + 50, y, 206, 20, this.display.getName());
        textField.setHoverText("display.hover.name", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + 253 + 52, y, 110, 20, new String[]{"display.show", "display.hide", "display.showAttacking"}, this.display.getShowName());
        button.setHoverText("display.hover.show.name", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, this.guiLeft + 259, y, 20, 20, Character.toString('\u21bb'));
        button.setHoverText("display.hover.random.name", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(15, this.guiLeft + 259 + 22, y, 20, 20, Character.toString('\u22ee'));
        button.setHoverText("display.hover.group.name", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "gui.title", this.guiLeft + 5, (y += 23) + 5));
        textField = new GuiNpcTextField(11, this, this.field_146289_q, this.guiLeft + 50, y, 186, 20, this.display.getTitle());
        textField.setHoverText("display.hover.subname", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lID++, "display.model", this.guiLeft + 5, (y += 23) + 5));
        button = new GuiNpcButton(1, this.guiLeft + 50, y, 110, 20, "selectServer.edit");
        button.setHoverText("display.hover.set.model", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "display.size", this.guiLeft + 175, y + 5));
        textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 203, y, 40, 20, this.display.getSize() + "");
        textField.setMinMaxDefault(1L, 30L, 5L);
        textField.setHoverText("display.hover.size", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lID++, "(1-30)", this.guiLeft + 246, y + 5));
        this.addLabel(new GuiNpcLabel(lID++, "display.texture", this.guiLeft + 5, (y += 23) + 5));
        textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 80, y, 200, 20, this.display.skinType == 0 ? this.display.getSkinTexture() : this.display.getSkinUrl());
        if (this.display.skinType == 1 && !this.display.getSkinPlayer().isEmpty()) {
            textField.func_146180_a(this.display.getSkinPlayer());
        }
        textField.setHoverText("display.hover.skin." + this.display.skinType, new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(3, this.guiLeft + 325, y, 38, 20, "mco.template.button.select");
        button.setHoverText("display.hover.texture.set", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 283, y, 40, 20, new String[]{"display.texture", "display.player", "display.url"}, this.display.skinType);
        button.setHoverText("display.hover.texture.type." + this.display.skinType, new Object[0]);
        this.addButton(button);
        this.getButton(3).setEnabled(this.display.skinType == 0);
        this.addLabel(new GuiNpcLabel(lID++, "display.cape", this.guiLeft + 5, (y += 23) + 5));
        textField = new GuiNpcTextField(8, this, this.field_146289_q, this.guiLeft + 80, y, 200, 20, this.display.getCapeTexture());
        textField.setHoverText("display.hover.cloak", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(8, this.guiLeft + 283, y, 80, 20, "display.selectTexture");
        button.setHoverText("display.hover.texture.cloak", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "display.overlay", this.guiLeft + 5, (y += 23) + 5));
        textField = new GuiNpcTextField(9, this, this.field_146289_q, this.guiLeft + 80, y, 200, 20, this.display.getOverlayTexture());
        textField.setHoverText("display.hover.eyes", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(9, this.guiLeft + 283, y, 80, 20, "display.selectTexture");
        button.setHoverText("display.hover.texture.eyes", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "display.livingAnimation", this.guiLeft + 5, (y += 23) + 5));
        button = new GuiNpcButton(5, this.guiLeft + 120, y, 50, 20, new String[]{"gui.yes", "gui.no"}, this.display.getHasLivingAnimation() ? 0 : 1);
        button.setHoverText("display.hover.animation", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "display.tint", this.guiLeft + 180, y + 5));
        StringBuilder color = new StringBuilder(Integer.toHexString(this.display.getTint()));
        while (color.length() < 6) {
            color.insert(0, "0");
        }
        textField = new GuiNpcTextField(6, this, this.guiLeft + 220, y, 60, 20, color.toString());
        textField.func_146193_g(this.display.getTint());
        textField.setHoverText("display.hover.color", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lID++, "display.shadow", this.guiLeft + 285, y + 5));
        button = new GuiNpcButton(4, this.guiLeft + 325, y, 50, 20, new String[]{"0%%", "50%%", "100%%", "150%%"}, this.display.getShadowType());
        button.setHoverText("display.hover.shadow", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID++, "display.visible", this.guiLeft + 5, (y += 23) + 5));
        button = new GuiNpcButton(7, this.guiLeft + 40, y, 50, 20, new String[]{"gui.yes", "gui.no", "gui.partly"}, this.display.getVisible());
        button.setHoverText("display.hover.visible", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(16, this.guiLeft + 92, y, 78, 20, "availability.available");
        button.setHoverText("display.hover.visible." + (CustomNpcs.EnableInvisibleNpcs ? 1 : 0), new Object[0]);
        this.addButton(button);
        this.getButton(16).setEnabled(this.enableInvisibleNpcs && this.display.getVisible() == 1);
        this.addLabel(new GuiNpcLabel(lID++, "display.interactable", this.guiLeft + 180, y + 5));
        int x = this.guiLeft + 240;
        button = new GuiNpcButton(13, x, y, 50, 20, new String[]{"gui.yes", "gui.no", "gui.solid"}, this.display.getHitboxState());
        button.setHoverText("display.hover.interactable", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(20, "W:", x += 54, y + 5));
        textField = new GuiNpcTextField(12, this, this.field_146289_q, x += 8, y + 1, 50, 18, this.df.format(this.display.width));
        float hitBoxWidth = this.npc.field_70130_N;
        if (this.npc instanceof EntityCustomNpc) {
            float scaleHead = 1.0f;
            float scaleBody = 1.0f;
            if (this.display.getModel() != null) {
                ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
                ModelPartConfig model = modeldata.getPartConfig(EnumParts.HEAD);
                scaleHead = Math.max(model.scale[0], model.scale[2]);
                model = modeldata.getPartConfig(EnumParts.BODY);
                scaleBody = Math.max(model.scale[0], model.scale[2]);
                hitBoxWidth = modeldata.entity.field_70130_N;
            }
            hitBoxWidth *= Math.max(scaleHead, scaleBody);
            hitBoxWidth = hitBoxWidth / 5.0f * (float)this.display.getSize();
        }
        textField.setMinMaxDoubleDefault(-1.0, 7.5, this.display.width);
        textField.setHoverText("display.hover.hitbox.width", ("" + (double)Math.round((double)this.baseHitBoxWidth * 1000.0) / 1000.0).replace(".", ","), ("" + (double)Math.round((double)hitBoxWidth * 1000.0) / 1000.0).replace(".", ","));
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(21, "H:", x += 54, y + 5));
        textField = new GuiNpcTextField(13, this, this.field_146289_q, x + 8, y + 1, 50, 18, this.df.format(this.display.height));
        float hitBoxHeight = this.npc.field_70131_O;
        if (this.npc instanceof EntityCustomNpc) {
            if (this.display.getModel() != null) {
                hitBoxHeight = ((EntityCustomNpc)this.npc).modelData.entity.field_70131_O;
            }
            hitBoxHeight = hitBoxHeight / 5.0f * (float)this.display.getSize();
        }
        textField.setMinMaxDoubleDefault(-1.0, 15.0, this.display.height);
        textField.setHoverText(new TextComponentTranslation("display.hover.hitbox.height", new Object[]{("" + (double)Math.round((double)this.baseHitBoxHeight * 1000.0) / 1000.0).replace(".", ","), ("" + (double)Math.round((double)hitBoxHeight * 1000.0) / 1000.0).replace(".", ",")}).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lID++, "display.bossbar", this.guiLeft + 5, (y += 23) + 5));
        button = new GuiNpcButton(10, this.guiLeft + 60, y, 110, 20, new String[]{"display.hide", "display.show", "display.showAttacking"}, this.display.getBossbar());
        button.setHoverText("display.hover.boss.bar", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lID, "gui.color", this.guiLeft + 180, y + 5));
        button = new GuiNpcButton(12, this.guiLeft + 220, y, 110, 20, this.display.getBossColor(), "color.pink", "color.blue", "color.red", "color.green", "color.yellow", "color.purple", "color.white");
        button.setHoverText("display.hover.bar.color", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void save() {
        if (this.display.skinType == 1) {
            this.display.loadProfile();
        }
        this.npc.textureLocation = null;
        this.field_146297_k.field_71438_f.func_72709_b((Entity)this.npc);
        this.field_146297_k.field_71438_f.func_72703_a((Entity)this.npc);
        Client.sendData(EnumPacketServer.MainmenuDisplaySave, this.display.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.display.readToNBT(compound);
        this.baseHitBoxWidth = this.npc.baseWidth;
        this.baseHitBoxHeight = this.npc.baseHeight;
        this.enableInvisibleNpcs = compound.func_74767_n("EnableInvisibleNpcs");
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 0: {
                if (!textfield.isEmpty()) {
                    this.display.setName(textfield.getFullText());
                }
                textfield.setFullText(this.display.getName());
                break;
            }
            case 2: {
                this.display.setSize(textfield.getInteger());
                break;
            }
            case 3: {
                if (this.display.skinType == 2) {
                    this.display.setSkinUrl(textfield.getFullText());
                    break;
                }
                if (this.display.skinType == 1) {
                    this.display.setSkinPlayer(textfield.getFullText());
                    break;
                }
                this.display.setSkinTexture(textfield.getFullText());
                break;
            }
            case 6: {
                int color;
                try {
                    color = Integer.parseInt(textfield.getFullText(), 16);
                }
                catch (NumberFormatException e) {
                    color = new Color(0xFFFFFF).getRGB();
                }
                this.display.setTint(color);
                ((GuiNpcTextField)textfield).func_146193_g(this.display.getTint());
                break;
            }
            case 8: {
                this.display.setCapeTexture(textfield.getFullText());
                break;
            }
            case 9: {
                this.display.setOverlayTexture(textfield.getFullText());
                break;
            }
            case 11: {
                this.display.setTitle(textfield.getFullText());
                break;
            }
            case 12: {
                float f = (float)textfield.getDouble();
                float f2 = this.display.width = f < 0.0f ? this.baseHitBoxWidth : f;
                if (!(f < 0.0f)) break;
                textfield.setFullText(this.df.format(this.display.width));
                break;
            }
            case 13: {
                float f = (float)textfield.getDouble();
                float f3 = this.display.height = f < 0.0f ? this.baseHitBoxHeight : f;
                if (!(f < 0.0f)) break;
                textfield.setFullText(this.df.format(this.display.height));
                break;
            }
        }
    }
}

